import os
import time

def search_in_files(folder_path, search_text):
    """
    在指定文件夹中搜索包含特定文本的文件，并显示匹配内容的上下文
    """
    found_files = []
    
    print(f"\n开始搜索 '{search_text}'...")
    print(f"搜索路径: {folder_path}\n")
    
    if not os.path.exists(folder_path):
        print(f"错误：文件夹 '{folder_path}' 不存在")
        return
    
    for root, dirs, files in os.walk(folder_path):
        for file in files:
            if file.endswith('.txt'):  # 可以根据需要修改文件类型
                file_path = os.path.join(root, file)
                try:
                    with open(file_path, 'r', encoding='utf-8') as f:
                        content = f.read()
                        if search_text in content:
                            found_files.append(file_path)
                            print(f"\n在文件 {file_path} 中找到匹配:")
                            
                            # 查找所有匹配位置并显示上下文
                            start = 0
                            while True:
                                pos = content.find(search_text, start)
                                if pos == -1:
                                    break
                                    
                                # 计算上下文的起始和结束位置
                                context_start = max(0, pos - 50)
                                context_end = min(len(content), pos + len(search_text) + 50)
                                
                                # 提取上下文
                                context = content[context_start:context_end]
                                
                                # 在上下文中高亮显示搜索文本
                                if context_start > 0:
                                    print("...")
                                print(f"{context}")
                                if context_end < len(content):
                                    print("...")
                                print("-" * 80)
                                
                                start = pos + 1
                                
                except Exception as e:
                    print(f"无法读取文件 {file_path}: {str(e)}")
    
    # 输出汇总结果
    if found_files:
        print(f"\n总共在 {len(found_files)} 个文件中找到 '{search_text}'：")
        for file_path in found_files:
            print(f"- {file_path}")
    else:
        print(f"\n没有找到包含 '{search_text}' 的文件")

def main():
    # 获取用户输入
    folder_path = input("请输入要搜索的文件夹路径: ")
    search_text = input("请输入要搜索的文本: ")
    
    # 执行搜索
    start_time = time.time()
    search_in_files(folder_path, search_text)
    end_time = time.time()
    
    # 显示搜索用时
    print(f"\n搜索完成，用时: {end_time - start_time:.2f} 秒")
    
    # 保持窗口打开
    input("\n按回车键退出...")

if __name__ == "__main__":
    main()
